REBOL []

stack: []

forth-rules: [
	any [
		set arg integer! ( append stack arg ) |
		'DUP (
			stack: head stack
			insert tail stack (last stack) ) |
		'SWAP (
			stack: head stack
			reverse/part stack 2 ) |
		'OVER (
			stack: head stack
			insert tail stack (pick stack ((length? stack) - 1)) )|
		'ROT (
			stack: head stack 
			insert tail stack (pick stack ((length? stack) - 2))
			stack: at stack ((length? stack) - 3)
			remove stack )|
		'-DUP (
			stack: head stack
			if (last stack) <> 0 [insert tail stack (last stack)] )|
		'DROP (
			stack: head stack
			stack: at stack (length? stack)
			remove stack) |
		'. ( 
			stack: head stack
			print last stack
			forth [ DROP ] ) |
		'= ( 
			stack: head stack
			fv1: pick stack ((length? stack) - 1)
			fv2: pick stack (length? stack)
			forth [ DROP DROP ]
			either (fv1 = fv2) [ 
				insert tail stack 1 
			] [ insert tail stack 0 ] ) |
		'IF set mot1 word! 'ELSE set mot2 word! 'THEN (
			stack: head stack
			fv1: last stack
			forth [ DROP ]
			either fv1 = 1 [
				forth to-block mot1
			] [ forth to-block mot2 ]
		)
	]
]

forth: function [ code ] [ fv1 fv2 ] [ 
	parse (compose code) forth-rules 
]


forth [
	10 20 OVER 30 SWAP ROT DUP 10 =
	IF . ELSE -DUP THEN
]

